package com.youdao.zhiyun.compositiondemo

import android.content.Intent
import android.os.Bundle
import android.util.Log
import android.view.View
import android.widget.AdapterView
import android.widget.ArrayAdapter
import android.widget.Toast
import androidx.appcompat.app.AppCompatActivity
import com.youdao.zhiyun.compositiondemo.databinding.ActivityChineseTextBinding
import com.youdao.compositioncorrection.CompositionCorrection
import com.youdao.compositioncorrection.CorrectListener
import com.youdao.compositioncorrection.model.ChineseGuidanceResult
import java.io.Serializable

class ChineseTextActivity : AppCompatActivity() {

      val grades = arrayOf(
        "一年级",
        "二年纪",
        "三年纪",
        "四年纪",
        "五年纪",
        "六年纪",
        "初一",
        "初二",
        "初三",
        "高一",
        "高二",
        "高三"
    )
    val gradeMap = mapOf(
        "一年级" to "g1",
        "二年纪" to "g2",
        "三年纪" to "g3",
        "四年纪" to "g4",
        "五年纪" to "g5",
        "六年纪" to "g6",
        "初一" to "g7",
        "初二" to "g8",
        "初三" to "g9",
        "高一" to "g10",
        "高二" to "g11",
        "高三" to "g12"
    )
    private  var grade =""
    private lateinit var binding: ActivityChineseTextBinding

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityChineseTextBinding.inflate(layoutInflater)
        setContentView(binding.root)
        initGradeSpSpinner()
    }
    private fun initGradeSpSpinner() {
        binding.spGrade.apply {
            prompt = "请选择作文等级"
            adapter = ArrayAdapter<String>(this@ChineseTextActivity, R.layout.item_grade, grades)
            setSelection(0)
            grade = gradeMap[grades[0]].toString()
            onItemSelectedListener = object : AdapterView.OnItemSelectedListener{
                override fun onItemSelected(p0: AdapterView<*>?, p1: View?, position: Int, p3: Long) {
                    Toast.makeText(this@ChineseTextActivity, "${grades[position]}", Toast.LENGTH_SHORT).show()
                    grade = gradeMap[grades[position]].toString()
                    Log.d("EnglishTextActivity", "onItemSelected:$grade ")
                }

                override fun onNothingSelected(p0: AdapterView<*>?) {
                }

            }

        }

    }

    fun guideComposition(view: View){
        CompositionCorrection.guideComposition("elementary","写一篇关于长城的作文", listener= object : CorrectListener {
            override fun onError(errorCode: Int?, msg: String?, requestId: String?) {
                Log.e(Companion.TAG, "onError:  errorCode:$errorCode,msg:$msg,requestId:$requestId", )
            }

            override fun onResult(result: Serializable, requestId: String) {
                runOnUiThread {
                    startActivity(Intent(this@ChineseTextActivity,CorrectResultActivity::class.java).apply {
                        putExtra("result",result as Serializable)
                        if (result is ChineseGuidanceResult){
                            putExtra("type","ch_text_guidance")
                        }else{
                            putExtra("type","ch_text")
                        }
                    })
                }
            }

        })
    }

    fun correct(view: View) {
//        if (binding.etContent.text.isEmpty()){
//            Toast.makeText(this, "作文内容不能为空", Toast.LENGTH_SHORT).show()
//            return
//        }
        val title = if ( binding.etTitle.text.toString().isEmpty() )null else binding.etTitle.text.toString()
        val requirement = if ( binding.etRequirement.text.toString().isEmpty() )null else binding.etRequirement.text.toString()
//        CompositionCorrectioner.correctionChineseText(input = binding.etContent.text.toString(),
        CompositionCorrection.correctionChineseText(input = CH_TEXT_TEST_DATA,
            listener= object : CorrectListener {
                override fun onError(errorCode: Int?, msg: String?, requestId: String?) {
                    Log.e(Companion.TAG, "onError:  errorCode:$errorCode,msg:$msg,requestId:$requestId", )
                }

                override fun onResult(result: Serializable, requestId: String) {
                    runOnUiThread {
                        startActivity(Intent(this@ChineseTextActivity,CorrectResultActivity::class.java).apply {
                            putExtra("result",result)
                            putExtra("type","ch_text")
                        })
                    }
                }

            },
            grade = grade,
            title = title,
            requirement = requirement
        )

    }

    companion object {
        private const val TAG ="ChineseTextActivity"
        private const val CH_TEXT_TEST_DATA ="""对那幅照片我一直不满意，是爷爷的一幅肖像照片，家里人都说挺好，后来以那幅照片为蓝本又做了瓷版画，但与记忆中的爷爷相去甚远。

我是爷爷奶奶带大的，在他们身边八年，记忆如磐石，刻骨铭心。两位老人早已离我远去，眼前却总模糊着爷爷踉跄的脚步，耳畔回荡着奶奶的哭泣，永红什么时候再回来啊?

尽管不能诠释内心记忆，但那幅照片我一直珍藏。后来，学会摄影后做的第一件事情就是翻拍那幅照片并放大，现仍在我的书房里挂着，那是记忆中爷爷唯一一幅照片。

岁月更替，手中有了相机，并从胶片到了数码，科技改变了一切。房间一角堆积的胶片、影集远远不如桌子上那个4T的硬盘所承载丰富，但点滴的记忆，前者所占更为丰满。

于是，内心常彷徨：我们少了什么?

胶片到数码，科技改变的不仅是摄影方式，更是生活方式。一部手机搞定一切，拍照、上网、购物、缴罚款……不经意间，地铁上人手一份的报纸悄然滑落;机场旅客手中的书籍寥寥无几;亲朋聚餐，开心的是这盘菜又可以发朋友圈。

科技是时代发展的产物。1912年，拉蒂格父亲送给他一部小相机的时候，很是稀罕新潮，那时起，他拍摄了他的上流社会家庭亲情。在那个大动荡时代，其行为仅如低头走路一般平凡甚至平庸，几十年后，这些照片成为整个法国社会的时代记忆，入展纽约现代艺术博物馆。

说到这里，我感觉，关于“胶片时代与数码技术时代”这个命题实则是个伪命题，最新的科技发明的确取代了旧技术，或许也取代了许多美好，但这些东西，或旧古董或新科技，永远只是一个工具。工具掌握人还是人掌握工具，这是个关键。或者说，这才是命题所指。

于是，悄然问自己，我，能做什么?

急剧变化的经济社会面前，我们是否眼光放得太远，而无力顾及身边——父母的健康，亲人的需求?

前天，在江西老家的三弟，把手机视频聊天功能打开，这是父母第一次使用，看到我在画面里，妈妈兴奋地说：“我看到你了，胡子又没刮。你看到我了吗?”镜头里，父母满面喜悦，绽放的笑容，抑制不住流淌。

有段时间没回家了，我想，得回去了。对了，父亲一直说要爷爷那幅照片，家里没有，这次也得带回去了。"""

    }
}