package com.youdao.zhiyun.compositiondemo

import android.os.Build
import android.os.Bundle
import android.view.View.GONE
import android.view.View.VISIBLE
import androidx.appcompat.app.AppCompatActivity
import com.youdao.compositioncorrection.model.ChineseResult
import com.youdao.compositioncorrection.model.EnglishResult
import com.youdao.compositioncorrection.model.ChineseGuidanceResult
import com.youdao.zhiyun.compositiondemo.databinding.ActivityCorrectResultBinding


class CorrectResultActivity : AppCompatActivity() {
    private lateinit var binding: ActivityCorrectResultBinding
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityCorrectResultBinding.inflate(layoutInflater)
        setContentView(binding.root)
        val type = intent.getStringExtra("type")

        when (type) {
            "en_text" -> englishText()
            "en_image" -> englishImage()
            "ch_text", "ch_image" -> chinese()
            "ch_text_guidance", "ch_image_guidance" -> chineseGuidance()
        }
    }


    fun chineseGuidance(){
        binding.tvSentences.visibility = GONE
        binding.tvExpectTitle.visibility = GONE
        binding.tvTotal.visibility = GONE
        binding.tvScoreInfo.visibility = GONE
        binding.tvReviews.visibility = GONE
        binding.tvTypo.visibility = GONE
        binding.tvGuidance.visibility = VISIBLE
        val result = intent.getSerializableExtra("result")!! as ChineseGuidanceResult
        binding.tvGuidance.text = "题目解析：\n${result.guidance.analysis}\n\n" +
                "段落分配：\n${result.guidance.paraAlloc}\n\n" +
                "核心观点：\n${result.guidance.corePoint}\n\n" +
                "素材参考：${result.guidance.material}\n"
    }

    private fun chinese() {
        val result: ChineseResult = if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.TIRAMISU) {
            intent.getSerializableExtra("result",ChineseResult::class.java)!!
        } else {
            intent.getSerializableExtra("result") as ChineseResult;
        }


        binding.tvTotal.text = "总分:${result.scoreCollection.score}分"
        binding.tvScoreInfo.text =
            "主题明确:\n${result.scoreCollection.perspectiveScore.themeExplicit}分\n" +
                    "符合题意:${result.scoreCollection.perspectiveScore.satisfyRequirement}分\n" +
                    "感情真挚:\n${result.scoreCollection.perspectiveScore.sentimentSincerity}分\n" +
                    "结构严谨:\n${result.scoreCollection.perspectiveScore.structureStrict}分\n" +
                    "语言流畅:\n${result.scoreCollection.perspectiveScore.essayFluence}分\n" +
                    "好词好句:\n${result.scoreCollection.perspectiveScore.goodSent}分\n"

        binding.tvReviews.text = "点评:\n${result.commentCollection.comment}"
        var typo: StringBuilder = StringBuilder()
        for ((index, item) in result.correctedContent.withIndex()) {
            var errorInfos = StringBuilder()
            for ((erroInfoIndex, erroInfoItem) in item.errorInfos.withIndex()) {
                errorInfos.append(
                    "${erroInfoIndex + 1}.原始片段的起始位置（相对于 orgSent、包含了空格等）${erroInfoItem.orgChunkStart}处，${
                        getErroType(
                            erroInfoItem.errorType
                        )
                    }\n"
                )
            }
            typo.append("原句${index + 1}:\n${item.orgSent}\n修改后结果:\n${item.corSent}\n错误原因:\n${errorInfos.toString()}")
            typo.append("\n\n")
        }
        binding.tvTypo.text = "智能纠错\n${typo}"
        if (result.commentCollection.expectTitle != null){
            binding.tvExpectTitle.text = "推荐标题：\n${result.commentCollection.expectTitle}\n"
            binding.tvExpectTitle.visibility = VISIBLE
        }
        val goodSentences: StringBuilder = StringBuilder()
        var index = 0;
        result.detailedEvaluation.sentenceEvaluation.forEach {
            if (it.type == "goodsent"){
                index += 1;
                goodSentences.append( "原句$index：\n${result.orgContent.substring(it.start,it.end)}\n")
                goodSentences.append("点评：\n${it.comment}\n\n")
            }
        }
        goodSentences.append("\n\n")
        binding.tvSentences.text = "好词好句:\n${goodSentences}"
        binding.tvSentences.visibility = if (index > 0) VISIBLE else GONE
    }

    private fun getErroType(errorType: String): String {

        val errorInfo = when (errorType) {
            "spell" -> "拼写错误"//	拼写错误包括了同音字错误等
            "space" -> "空格错误"//	与空格相关的各种错误
            "punct" -> "标点错误"//	与标点符号相关的各种错误
            "grammar" -> "语法错误"//	上述错误之外的错误，会被划分为语法错误
            else -> ""
        }
        return errorInfo
    }

    private fun englishImage() {
        val result: EnglishResult = if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.TIRAMISU) {
            intent.getSerializableExtra("result",EnglishResult::class.java)!!
        } else {
            intent.getSerializableExtra("result") as EnglishResult;
        }
        binding.tvTotal.text = "总分:${result.totalScore}分"
        binding.tvScoreInfo.text = "词汇得分:${result.majorScore.wordScore}分\n" +
                "语法得分:${result.majorScore.grammarScore}分\n" +
                "内容得分:${result.majorScore.topicScore}分\n" +
                "逻辑分:${result.majorScore.structureScore}分"
        binding.tvReviews.text = "点评:${result.essayAdvice}"
        var typo: StringBuilder = StringBuilder()
        for ((index, item) in result.essayFeedback.sentsFeedback.withIndex()) {
            typo.append("原句${index + 1}:\n${item.rawSent}\n修改后结果:\n${item.correctedSent}\n错误原因:\n${item.sentFeedback}")
            typo.append("\n\n")
        }

        binding.tvTypo.text = "智能纠错\n${typo.toString()}"

        if (result.essayReport != null){
            binding.tvAdvanced.visibility = VISIBLE;
            binding.tvAdvanced.text = "高级功能\n ${result.essayReport.avgSentLenAdvice} \n${result.essayReport.avgWordLenAdvice} \n${result.essayReport.essayAdvice}"
        }
    }

    private fun englishText() {
        val result: EnglishResult = if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.TIRAMISU) {
            intent.getSerializableExtra("result",EnglishResult::class.java)!!
        } else {
            intent.getSerializableExtra("result") as EnglishResult;
        }
        //val result = intent.getSerializableExtra("result")!! as EnglishResult
        binding.tvTotal.text = "总分:${result.totalScore}分"
        binding.tvScoreInfo.text = "词汇得分:${result.majorScore.wordScore}分\n" +
                "语法得分:${result.majorScore.grammarScore}分\n" +
                "内容得分:${result.majorScore.topicScore}分\n" +
                "逻辑分:${result.majorScore.structureScore}分"
        binding.tvReviews.text = "点评:${result.essayAdvice}"
        var typo: StringBuilder = StringBuilder()
        for ((index, item) in result.essayFeedback.sentsFeedback.withIndex()) {
            typo.append("原句${index + 1}:\n${item.rawSent}\n修改后结果:\n${item.correctedSent}\n错误原因:\n${item.sentFeedback}")
            typo.append("\n\n")
        }

        binding.tvTypo.text = "智能纠错\n${typo.toString()}"

        if (result.essayReport != null){
            binding.tvAdvanced.visibility = VISIBLE;
            binding.tvAdvanced.text = "高级功能\n ${result.essayReport.avgSentLenAdvice} \n${result.essayReport.avgWordLenAdvice} \n${result.essayReport.essayAdvice}"
        }

    }
}