package com.youdao.zhiyun.compositiondemo

import android.app.AlertDialog
import android.content.DialogInterface
import android.content.Intent
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.view.View
import android.webkit.WebView
import android.webkit.WebViewClient

class MainActivity : AppCompatActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)
        // 显示隐私政策弹窗
        showPrivacyPolicyDialog()
    }

    fun englishImage(view: View) = startActivity(Intent(MainActivity@this, EnglishImageActivity::class.java))
    fun englishText(view: View)= startActivity(Intent(MainActivity@this, EnglishTextActivity::class.java))
    fun chineseText(view: View) = startActivity(Intent(MainActivity@this, ChineseTextActivity::class.java))
    fun chineseImage(view: View)= startActivity(Intent(MainActivity@this, ChineseImageActivity::class.java))

    private fun showPrivacyPolicyDialog() {
        val dialogView = layoutInflater.inflate(R.layout.dialog_privacy_policy, null)
        val webView: WebView = dialogView.findViewById(R.id.webViewPrivacyPolicy)

        // 加载隐私政策内容，可以是本地HTML文件或远程URL
        webView.webViewClient = WebViewClient()
        webView.settings.javaScriptEnabled = true
        webView.loadUrl("file:///android_asset/privacy_240604.html") // 本地文件
        // webView.loadUrl("https://www.example.com/privacy_policy") // 远程URL

        val builder = AlertDialog.Builder(this)
        builder.setTitle("隐私政策")
        builder.setView(dialogView)
        builder.setPositiveButton("同意", DialogInterface.OnClickListener { dialog, which ->
            // 用户同意隐私政策的逻辑
            dialog.dismiss()
        })
        builder.setNegativeButton("不同意", DialogInterface.OnClickListener { dialog, which ->
            // 用户不同意隐私政策的逻辑
            dialog.dismiss()
            finish()
        })
        builder.setCancelable(false) // 禁止用户通过点击外部区域关闭弹窗
        builder.show()
    }

    override fun onBackPressed() {
        //super.onBackPressed()
        finish();
    }
}