/*
 * Decompiled with CFR 0.152.
 */
package com.youdao.sdk.ydtranslate;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import com.youdao.sdk.app.Language;
import com.youdao.sdk.app.YouDaoApplication;
import com.youdao.sdk.common.Constants;
import com.youdao.sdk.common.YDUrlGenerator;
import com.youdao.sdk.ydtranslate.TranslateSdk;
import java.util.Map;
import java.util.Random;

public final class TranslateParameters {
    private final String mSource;
    private final Language mFrom;
    private final Language mTo;
    private final int mTimeout;
    private final boolean useAutoConvertLine;
    private final boolean useAutoConvertWord;
    private final boolean ttsVoiceStrict;
    private final String mVoice;
    private final String mstrict;
    private final String mSound;

    public TranslateParameters(Builder builder) {
        this.mSource = builder.source;
        this.mFrom = builder.from;
        this.mTo = builder.to;
        this.mTimeout = builder.timeout;
        this.useAutoConvertLine = builder.useAutoConvertLine;
        this.useAutoConvertWord = builder.useAutoConvertWord;
        this.mSound = builder.sound;
        this.mVoice = builder.voice;
        this.mstrict = builder.strict;
        this.ttsVoiceStrict = builder.ttsVoiceStrict;
    }

    public boolean isTtsVoiceStrict() {
        return this.ttsVoiceStrict;
    }

    public final String getSource() {
        return this.mSource;
    }

    public final String getAppKey() {
        return YouDaoApplication.mAppKey;
    }

    public Language getFrom() {
        Object object = object.mFrom;
        if (object == null) {
            return Language.CHINESE;
        }
        return object;
    }

    public Language getTo() {
        Object object = object.mTo;
        if (object == null) {
            return Language.ENGLISH;
        }
        return object;
    }

    public Map<String, String> params(Context context, String string) {
        TranslateSdk translateSdk;
        TranslateParameters translateParameters = this;
        String string2 = translateParameters.getAppKey();
        YDUrlGenerator yDUrlGenerator = new YDUrlGenerator(context);
        yDUrlGenerator.withAppKey(string2);
        Map<String, String> map = yDUrlGenerator.generateUrlMap();
        if (translateParameters.getFrom() != null) {
            map.put("from", this.getFrom().getCode());
        }
        if (this.getTo() != null) {
            map.put("to", this.getTo().getCode());
        }
        Map<String, String> map2 = map;
        Map<String, String> map3 = map;
        int n2 = new Random().nextInt(1000);
        TranslateSdk translateSdk2 = translateSdk;
        translateSdk2();
        String string3 = String.valueOf(n2);
        string3 = translateSdk.sign(context, string2, string, string3, "", "v1");
        map.put("q", string);
        map3.put("salt", String.valueOf(n2));
        map3.put("signType", "v1");
        map3.put("docType", "json");
        map3.put("sign", string3);
        map2.put("source", this.mSource);
        map2.put("offline", "0");
        map.put("sound", this.mSound);
        map.put("voice", this.mVoice);
        map.put("strict", this.mstrict);
        map.put("ttsVoiceStrict", String.valueOf(this.ttsVoiceStrict));
        int n3 = this.mTimeout;
        if (n3 > 0) {
            map.put("timeout", String.valueOf(n3));
        }
        return map;
    }

    public boolean isUseAutoConvertLine() {
        return this.useAutoConvertLine;
    }

    public boolean isUseAutoConvertWord() {
        return this.useAutoConvertWord;
    }

    public final int getTimeout() {
        int n2 = this.mTimeout;
        if (n2 < 1) {
            return 10000;
        }
        return n2;
    }

    public String paramString(Context object, String string) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        Map<String, String> map = ((TranslateParameters)((Object)stringBuilder2)).params((Context)object, string);
        stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder("");
        for (Map.Entry entry : map.entrySet()) {
            string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            if (TextUtils.isEmpty((CharSequence)string2)) continue;
            stringBuilder2.append(string).append("=").append(Uri.encode((String)string2)).append("&");
        }
        return stringBuilder2.toString();
    }

    public String getTranslateType() {
        if (this.mFrom == Language.SPANISH && this.mTo == Language.CHINESE) {
            return this.mTo.getCode() + "-" + this.mFrom.getCode();
        }
        return this.mFrom.getCode() + "-" + this.mTo.getCode();
    }

    public static final class Builder {
        private String source;
        private Language from;
        private Language to;
        private int timeout;
        private boolean useAutoConvertLine = true;
        private boolean useAutoConvertWord = true;
        private boolean ttsVoiceStrict = false;
        private String voice = Constants.VOICE_GIRL_US;
        private String strict = Constants.TRANS_STRICT;
        private String sound = Constants.SOUND_OUTPUT_MP3;

        public final Builder voice(String string) {
            this.voice = string;
            return this;
        }

        public final Builder sound(String string) {
            this.sound = string;
            return this;
        }

        public final Builder source(String string) {
            this.source = string;
            return this;
        }

        public final Builder from(Language language) {
            this.from = language;
            return this;
        }

        public final Builder to(Language language) {
            this.to = language;
            return this;
        }

        public final Builder timeout(int n2) {
            this.timeout = n2;
            return this;
        }

        public final Builder strict(String string) {
            this.strict = string;
            return this;
        }

        public final Builder useAutoConvertLine(boolean bl) {
            this.useAutoConvertLine = bl;
            return this;
        }

        public final Builder useAutoConvertWord(boolean bl) {
            this.useAutoConvertWord = bl;
            return this;
        }

        public final Builder ttsVoiceStrict(boolean bl) {
            this.ttsVoiceStrict = bl;
            return this;
        }

        public final TranslateParameters build() {
            return new TranslateParameters(this);
        }
    }
}

