package com.youdao.zhiyun.compositiondemo

import android.content.Intent
import android.os.Bundle
import android.util.Log
import android.view.View
import android.widget.AdapterView
import android.widget.ArrayAdapter
import android.widget.Toast
import androidx.appcompat.app.AppCompatActivity
import com.youdao.compositioncorrection.CompositionCorrection
import com.youdao.compositioncorrection.CorrectListener
import com.youdao.zhiyun.compositiondemo.databinding.ActivityEnglishTextBinding
import java.io.Serializable

class EnglishTextActivity : AppCompatActivity() {
    val EN_TEXT_TEST_DATA ="""The most meaningful activity I took part in at school When I was a Junior 3 student, I was very shy. I wasn't brave enough to take part in any school activities. But when I became a Junior 4 student, an activity changed my personalities. As a Junior 4 student, I felt I was under great stress. But this stress didn't stop me from thinking to attend the biggist activity in our school. Because of my shy personality, I hesitated for many times. But at last, in order to realize my statge dream, I took part in the activity. I performed very well for I knew it was the last time I could attend. I was surprised at how brave I was that time. Sometimes, one person want to succeed in doing one thing, then, he must be brave, or he must fail."""
//    val EN_TEXT_TEST_DATA = "1. What is 有道写作?\n" +
//            "有道写作 (Uwrite) is a advanced English writing software designed for Chinese people\n" +
//            "2. New updates?\n" +
//            "(1) A more comprehensive correction system for English writing：Writing error are classified into four dimentions: correctness, clarity, diversity and language style. The causes of errors and grammar points are all explained in detail.\n" +
//            "(2) Bilingual writing: To write more efficient when writing in Chinese or 中英混合的 sentences."
   private val  TAG  = "EnglishTextActivity"
    val grades = arrayOf(
        "默认",
        "小学",
        "高中",
        "四级",
        "六级",
        "考研",
        "托福",
        "GRE",
        "雅思"
    )
    val gradeMap = mapOf(
        "默认" to "default",
        "小学" to "elementary",
        "高中" to "high",
        "四级" to "cet4",
        "六级" to "cet6",
        "考研" to "graduate",
        "托福" to "toefl",
        "GRE" to "gre",
        "雅思" to "ielts",
    )
    private  var grade =""
    private lateinit var binding: ActivityEnglishTextBinding
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityEnglishTextBinding.inflate(layoutInflater)
        setContentView(binding.root)
        initGradeSpSpinner()

    }

    private fun initGradeSpSpinner() {
        binding.spGrade.apply {
            prompt = "请选择作文等级"
            adapter = ArrayAdapter<String>(this@EnglishTextActivity, R.layout.item_grade, grades)
            setSelection(0)
            grade = gradeMap[grades[0]].toString()
            onItemSelectedListener = object : AdapterView.OnItemSelectedListener{
                override fun onItemSelected(p0: AdapterView<*>?, p1: View?, position: Int, p3: Long) {
                    Toast.makeText(this@EnglishTextActivity, "${grades[position]}", Toast.LENGTH_SHORT).show()
                    grade = gradeMap[grades[position]].toString()
                    Log.d("EnglishTextActivity", "onItemSelected:$grade ")
                }

                override fun onNothingSelected(p0: AdapterView<*>?) {
                }

            }

        }

    }

    fun correct(view: View) {
//        if (binding.etContent.text.isEmpty()){
//            Toast.makeText(this, "作文内容不能为空", Toast.LENGTH_SHORT).show()
//            return
//        }
        val title = if ( binding.etTitle.text.toString().isEmpty() )null else binding.etTitle.text.toString()
        val modelContent = if ( binding.etModelContent.text.toString().isEmpty() )null else binding.etModelContent.text.toString()
        val goodExpression = if ( binding.etGoodExpression.text.toString().isEmpty() )null else binding.etGoodExpression.text.toString()
        val limitedWords = if ( binding.etLimitedWords.text.toString().isEmpty() )null else binding.etLimitedWords.text.toString()

//        CompositionCorrectioner.correctionEnglishText(input = binding.etContent.text.toString(),
        CompositionCorrection.correctionEnglishText(input = EN_TEXT_TEST_DATA,
            listener= object :CorrectListener{
                override fun onError(errorCode: Int?, msg: String?, requestId: String?) {
                    Log.e(TAG, "onError:  errorCode:$errorCode,msg:$msg,requestId:$requestId", )
                }

                override fun onResult(result: Serializable, requestId: String) {
                    runOnUiThread {
                        startActivity(Intent(this@EnglishTextActivity,CorrectResultActivity::class.java).apply {
                            putExtra("result",result )
                            putExtra("type","en_text")
                        })
                    }
                }

            },
            grade = grade,
            title = title ,
            modelContent = modelContent,
            goodExpression= goodExpression,
            needTypo = binding.cbNeedTypo.isChecked,
            limitedWords =limitedWords,
            isNeedSynonyms=binding.cbIsNeedSynonyms.isChecked,
            isNeedAdvanced = binding.cbIsAdvanced.isChecked
            )

    }
}