package com.youdao.aicloud.translate;

import com.alibaba.fastjson.JSONObject;
import com.youdao.aicloud.translate.utils.AuthV3Util;
import com.youdao.aicloud.translate.utils.HttpUtil;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

/**
 * 网易有道智云PDF格式转换（高级版）服务api调用demo
 * 接口文档：https://ai.youdao.com/DOCSIRMA/html/ocr/api/pdf-wd-premium/index.html
 */
public class PdfConvertV2Demo {

    private static final String CODE_SUCESS = "0";
    private static final String BASEURL = "https://openapi.youdao.com/file_convert/v2";
    private static final String UPLOAD_URI = "/upload";
    private static final String QUERY_URI = "/query";

    private static final Integer STATUS_SUCCESS = 4;
    private static final Integer STATUS_FAIL = -2;

    private static final long QUERY_INTERVAL_MS = 3000L;
    private static final long QUERY_TIMEOUT_MS = 5*60*1000L;

    private static final String APP_KEY = "";     // 您的应用ID
    private static final String APP_SECRET = "";  // 您的应用密钥

    // 本地待转换PDF文件路径
    private static final String PATH = "~/example.pdf";

    public static void main(String[] args) throws NoSuchAlgorithmException, IOException, InterruptedException {
        // upload
        String pdfBase64Str = getFileBase64(PATH);
        String fileName = new File(PATH).getName();
        Map<String, String[]> uploadParams = new HashMap<String, String[]>() {{
            put("q", new String[]{pdfBase64Str});
            put("fileName", new String[]{fileName});
            put("fileType", new String[]{"pdf"});
            // 转换为 docx 格式
            put("targetFileType", new String[]{"docx"});
        }};
        AuthV3Util.addAuthParams(APP_KEY, APP_SECRET, uploadParams);
        Map<String, String[]> header = new HashMap<String, String[]>() {{
           put("Content-Type", new String[]{"multipart/form-data"});
        }};
        byte[] uploadResult = HttpUtil.doPostFormData(String.format("%s%s", BASEURL, UPLOAD_URI), header, uploadParams, "application/json");
        if (uploadResult == null) {
            System.out.println("upload failed");
            return;
        }
        JSONObject uploadJsonObject = JSONObject.parseObject(new String(uploadResult, StandardCharsets.UTF_8));
        String uploadCode = uploadJsonObject.getString("code");
        if (!CODE_SUCESS.equals(uploadCode)) {
            System.out.println("upload response code " + uploadCode + " uploadResult " + new String(uploadResult, StandardCharsets.UTF_8));
            return;
        }
        String flowNumber = uploadJsonObject.getJSONObject("data").getString("flownumber");

        // query
        long queryStart = System.currentTimeMillis();
        System.out.println("the convert flownumber is: " + flowNumber);
        while (System.currentTimeMillis() - queryStart <= QUERY_TIMEOUT_MS) {
            // 添加请求参数
            Map<String, String[]> params = new HashMap<String, String[]>() {{
                put("flownumber", new String[]{flowNumber});
                // 这里只是为了鉴权参数填充，后面需移除
                put("q", new String[]{flowNumber});
            }};
            // 添加鉴权相关参数
            AuthV3Util.addAuthParams(APP_KEY, APP_SECRET, params);
            params.remove("q");

            // 请求api服务
            byte[] queryResult = HttpUtil.doPostFormData(String.format("%s%s", BASEURL, QUERY_URI), header, params, "application/json");
            // 打印返回结果
            if (queryResult == null) {
                System.out.println("query failed");
            }
            JSONObject queryJsonObject = JSONObject.parseObject(new String(queryResult, StandardCharsets.UTF_8));
            String queryCode = queryJsonObject.getString("code");
            if (!CODE_SUCESS.equals(queryCode)) {
                System.out.println("query " + flowNumber + " response code " + uploadCode + " uploadResult " + new String(uploadResult, StandardCharsets.UTF_8));
                return;
            }
            Integer taskStatus = queryJsonObject.getJSONObject("data").getInteger("status");
            if (STATUS_SUCCESS.equals(taskStatus)) {
                System.out.println(flowNumber + "complete, resultUrl: " + queryJsonObject.getJSONObject("data").get("resultUrl"));
                return;
            } else if (STATUS_FAIL.equals(taskStatus)) {
                System.out.println(flowNumber + "failed");
                return;
            }
            System.out.println("query " + flowNumber + " interval");
            Thread.sleep(QUERY_INTERVAL_MS);
        }
        System.out.println("query convert flownumber " + flowNumber + "timeout");
        System.exit(1);
    }

    private static String getFileBase64(String filePath) throws IOException {
        File file = new File(filePath);

        // 检查文件是否存在
        if (!file.exists()) {
            throw new IOException("文件不存在: " + filePath);
        }

        // 检查是否是文件（不是目录）
        if (!file.isFile()) {
            throw new IOException("路径不是文件: " + filePath);
        }

        // 使用try-with-resources自动关闭流
        try (FileInputStream fileInputStream = new FileInputStream(file)) {
            // 创建字节数组，大小为文件长度
            byte[] fileBytes = new byte[(int) file.length()];

            // 读取文件内容到字节数组
            int bytesRead = fileInputStream.read(fileBytes);
            if (bytesRead != file.length()) {
                throw new IOException("文件读取不完整");
            }

            // 使用Java 8的Base64编码器进行编码
            return Base64.getEncoder().encodeToString(fileBytes);
        }

    }


}
